###################################################################################
#The MIT License (MIT)                                                            #
# Copyright(C) 2015 Daisuke Tajima. All rights reserved.                          #
#                                                                                 #
# Permission is hereby granted, free of charge, to any person obtaining a copy    #
# of this software and associated documentation files (the "Software"), to deal   #
# in the Software without restriction, including without limitation the rights    #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell       #
# copies of the Software, and to permit persons to whom the Software is           #
# furnished to do so, subject to the following conditions:                        #
#                                                                                 #
# The above copyright notice and this permission notice shall be included in      #
# all copies or substantial portions of the Software.                             #
#                                                                                 #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,        #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE     #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER          #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,   #
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN       #
# THE SOFTWARE.                                                                   #
#                                                                                 #
#                                                     tajima.d.aa@m.titech.ac.jp  #
################################################################################### 

install.packages( "kernlab" )
library(kernlab);

#Set the directrory where sample code and data set exist.
setwd("C:\\workspace\\");

#Define number of the participant.
N = 10;

###########################################
#  Code for using Support Vector machine  #
###########################################

#Set participant's number
for(num in c(1:N)){
		
	#Load data set
	file <- paste("subject_",num,".csv", sep="");
	DataSet <- read.csv(file);

	#Set condition nunber
	for(i in c(1,2)){

		#Load data set consisted of right hand position and participant's response
		Points <- data.frame(DataSet[(3*i-1):(3*i-2)],DataSet[3*i]);
		FirstPosition <- Points[1,2:1];

		for (k in 1:nrow(Points)){

			#if(Points[k,1] > 100 || Points[k,2] > 100)	Points[k,] <- c(NaN , NaN, "no");

			Points[k,2:1] <- Points[k,2:1] - FirstPosition;
			Points[k,1] <- -Points[k,1];
		}

		# classifying the participant's response by support vector machine	
		switch(i,
			(Ksvm <- ksvm(Answer_1~., data = Points, type = "C-svc", kernel = "rbfdot", cross = 8,prob.model=TRUE,cache = 40)),
			(Ksvm <- ksvm(Answer_2~., data = Points, type = "C-svc", kernel = "rbfdot", cross = 8,prob.model=TRUE,cache = 40)),
		)

		#plot the result of cassification
		plot(Ksvm, data = Points[2:1], asp = 1, xlim=c(-30,30), ylim = c(-30,30))
		
		show(paste("i =", i ,",num =", num));
		show(Ksvm)
	

		#Save probabilities of participant's responce at each positions.
		separation = 0.2;

		list <- seq(-30,30,by = separation);	
		val <- matrix(0,ncol = length(list), nrow = length(list));
	
		for( k in 1:length(list)){
	
			position <- matrix(0, ncol = 2, nrow = length(list));
			position[,1] = list;				#y axis data
			position[,2] = separation * (k-1) - 30;		#x axis data
		
			val[,k] <- predict(Ksvm, position, type = "probabilities")[,2];
		}
	
		val_tmp <- t(val);

		decision_val = as.data.frame(val_tmp);
	
		rownames(decision_val) <- 	list;
		colnames(decision_val) <- 	list;

		file <- paste("probabilities_val_",num,"_",i,".csv", sep="");
		write.csv(decision_val, file = file);

	}


	rm(DataSet);
}

########################################################
#  Code for visualizing the result within particpants  #
########################################################

#Parameter for visible range of the graph.
range = 20;

#Set condition nunber
for( i in c(1:2)){

	#Set participant's number
	for(num in c(1:N)){

		#Load DataSet
		file <- paste("subject_",num,".csv", sep="");
		DataSet <- read.csv(file);
	
		Points <- data.frame(DataSet[(3*i-1):(3*i-2)],DataSet[3*i]);
			
		FirstPosition <- Points[1,2:1];
				
		for (k in 1:nrow(Points)){
	
			#if(Points[k,1] > 100 || Points[k,2] > 100)	Points[k,] <- c(NaN , NaN, NaN);
	
				Points[k,2:1] <- Points[k,2:1] - FirstPosition;
				Points[k,1] <- -Points[k,1];
		}
	
		#Load probabilities of participant's responce at each positions.
		file <- paste("probabilities_val_", num, "_", i, ".csv", sep = "");
		a <-  read.csv(file, row.names = 1);
	
		Raw.Yes <- switch(i,
					Points[Points$Answer_1 == "yes",],
					Points[Points$Answer_2 == "yes",],
					);
		Raw.No  <- switch(i,
					Points[Points$Answer_1 == "no",],
					Points[Points$Answer_2 == "no",],
					);
		
		#Visualizing the result as graph
		file <- paste("RawData_and_Contour_", num, "_",i,".bmp", sep="");
		bmp(file,width = 800, height = 800, pointsize = 24);
		
		par("oma" = c(0,1,0,0));
		
		image(seq(-30,30,by = separation), seq(-30,30,by = separation), as.matrix(a),
		xlim= c(-range,range),ylim= c(-range,range),zlim= c(0,1),
		col = c("#ebf9f8","#fcbccb"),
		tck = 0.02,
		xlab = "Horizontal position offset (cm)",
		ylab = "Vertical position offset (cm)",
		asp = 1, cex.axis = 1.4, las = 1, cex.lab = 1.4
		);

		switch(i,
			(title(main = "Mirror condtion")),
			(title(main = "Blackboard condition"))	
		);

		axis(side = 1, tck = 0.02, las = 1, cex.axis = 1.4);
		axis(side = 2, tck= 0.02, las = 1, cex.axis = 1.4);
		box();
	
		contour(seq(-30,30,by = separation), seq(-30,30,by = separation), as.matrix(a),
		xlim= c(-range,range),ylim= c(-range,range),zlim= c(-3,3),
		add = T, level=  .5,tck = 0.02,
		asp = 1, labcex = 0.1, lwd = 4);
	
	
		points(Raw.Yes[,2], Raw.Yes[,1], pch = 16,xlim = c(-range,range), ylim = c(-range,range), cex = 1.5);
		points(Raw.No[,2], Raw.No[,1], pch = 1, xlim = c(-range,range), ylim = c(-range,range), cex = 1.5);
	
		legend("bottomright",c("Yes","No"), bg ="white", pch = c(16,1), cex = 1.2);
	
		dev.off();
	}
}

#########################################################
#  Code for visualizing the result between participants #
#########################################################

file <- paste("contour_average.bmp");
bmp(file,width = 800, height = 800, pointsize = 24);

par("oma" = c(0,1,0,0));
range = 20;

for(i in c(1:2)){

	file <- paste("probabilities_val_1_",i,".csv", sep = "");
	a <-  read.csv(file, row.names = 1);

	for(j in c(2:N)){
		file <- paste("probabilities_val_",j,"_",i,".csv", sep = "");
		a <- as.data.frame((as.matrix(a) +  as.matrix(read.csv(file, row.names = 1))));
	}

	a <- as.data.frame((as.matrix(a)/N));
	list <- seq(-30,30,by = separation);

	#Mirror
	if(i == 1){

		image(list, list, as.matrix(a),
		xlim= c(-range,range),ylim= c(-range, range),zlim= c(0,1),
		col = c("#ebf9f8","#fcbccb"),
		tck = 0.02,
		xlab = "Horizontal position offset (cm)",
		ylab = "Vertical position offset (cm)",
		asp = 1, cex.axis = 1.4, las = 1, cex.lab = 1.4
		);

		axis(side = 1, tck = 0.02, las = 1, cex.axis = 1.4);
		axis(side = 2, tck= 0.02, las = 1, cex.axis = 1.4);
		box();

		contour(list,list,as.matrix(a),
		col = gray(0),
		add = T, level=  .5,tck = 0.02,
		asp = 1, labcex = 0.1, lty = 1, lwd = 4,
		xlim= c(-range,range), ylim= c(-range,range));
	}

	#Blackboard
	if(i == 2){

		contour(list,list,as.matrix(a),
		col = grey(0),
		add = T, level=  .5,tck = 0.02,
		asp = 1, labcex = 0.1, lty = 3, lwd = 4,
		xlim= c(-range,range), ylim= c(-range,range));

	}
}

legend("bottomright",c("Mirror","BlackBoard"), bg ="white", lty= c(1,3),lwd = c(4,4), bty = "n", cex = 1.15);

dev.off();

